		0
		INITIALIZE()
		MSG(Text='ENTER executes next line.||Run full speed: click menu RUN')

....			Basics
.
.	More: press F1 >>>Sample  1 Centigrade Fahrenheit.hic<<<
.

.	A dot "."	as first non-blank character of a line makes this line a comment
.	hic		is the standard extension of HicEst files
.	New line	Control+Enter, or Enter at (line end + 1)
.	$		as first letter of a variable name makes it global, else local to function.
.	variables	variable names start with letter or $.
.	$AppDataPath	is the directory to save scripts or files (if no extra HicEst folder)
.	Get Help	Press F1 over query, or right mouse for context-sensitive help
.			When a window opens it can be single-stepped or run
.	Right-Mouse	click in script is the same as F1
.	More help	Menu Help/Help file. Menu Help.  Keywords at top of page can be extended by F1.
.	A "!"		anywhere makes rest of line a comment
.	A Hash "#"	# in column 1 terminates compilation. Use following text as string constant.
.	Results	short form shown in left column. Long form use MSG, DLG, x-y graphs etc.
.	Status bar	shows variable or auto-completion (TAB for next, Space to accept)
.	INS or OVR	to indicate INSert or OVeRwrite mode
.	Errors		identify the source from the error code in left-hand column.
.	ReLoad menu	optional save and reload script + reCompile (if you cannot believe a result)
.	Run script	Alt+R, or Menu/Run
.	Step script	Enter, or Menu/Step
.	Find menu	Find. Plus Shift = find backward. Plus CTRL = find full word.
.	Search menu	search text under cursor. Plus CTRL = search full word. Plus Shift = search up.
.	Timer menu	Take a break. Set timer to pause, either minutes, or absolute (hour minute).
.	Font Size	Control+Plus, Control+Minus, or Control+mouse wheel
.	Indentation	Indentation of line 1 determines indent of ALL NON-COMMENT lines
.	Line 1		ALWAYS EXECUTED at load time (Function call in line 1 serves to run script at startup)
.	Escape #1	stops Run-mode, or deletes DLG window
.	Escape #2	deletes POPup window (if present)
.	Escape #3	deletes tooltip window (if present) and
.			clears result column (including bookmarks)
.	Bookmarks	A click to result column toggles a bookmark
.	Upper case	letters of keywords MUST be written (in upper or lower case)
.	Lower case	letters of keywords CAN be written
.	Continuation	lines are possible after any of , ; = . or vertical bar

....			Debug
.	Line by line	ENTER, or Menu/Step
.	Function debug	To debug a function: Shift + ENTER to STEP in or out of function
.	Result area	left column shows short result while in Step-mode
.	Status bar	shows eg variable values
.	MSG(T="Hi")	stops Run-mode temporarily, displays num or text message, waits for confirm
.	DLG()		change values, both wait or noWait. Allows many variables.
.	BREAK ! text	stops Run-mode temporarily, displays MSG (with trailing text)
.	IF(c) BREAK	conditional break. IF(c_does_not_evaluate_to_0) BREAK
.	FUNCTION	insert test calls, easily moved or removed
.	BEEP(freq)	make noise of frequency freq, eg beep(440)
.	BEEP(text)	plays text notation, eg beep('c e g')
.	POP(variables)	shows values, dont wait
.	F2()..F12()	functions callable programatically or by key or by mouse.

....			Operators
.
. !		! starts a comment anywhere in the line
. .		dot IN COLUMN 1: starts a line comment

. +		Addition  (Note: + doubles as logical OR in IF(a + b))
		IF (1 + 2 ~ 3) BREAK

. -		Subtraction
		IF (1 - 2 ~ -1) BREAK

. *		Multiplication  (Note: * doubles as logical AND in IF(a * b))
		IF (1.23 * 10 ~ 12.3) BREAK

. /		Division
		IF (1.23 / 10 ~ 0.123) BREAK

. ^		Power
		IF (4 ~ NINT(16 ^ 0.5)) BREAK

. =		Equals
		num = 2 + 1/4
		string = 'A' && "B"
		if (num ~ 2.25) BREAK

. <		less than (0 is false, not 0 is true)
		if (3 < 2) BREAK
		if ('b' < 'a') BREAK

. <=		less than or equal (0 is false, not 0 is true)
		if (3 <= 2) BREAK
		if ('b' <= 'a') BREAK	! lexical order

. ==		Equality (0 is false, not 0 is true)
		if (0 == 2 - 1) BREAK
		if ('ab' == 'A' & 'B') BREAK

. ~		not equal to (0 is false, not 0 is true)
		if (0 ~ (2 - 1 - 1)) BREAK
		if ('ab' ~ 'a' & 'b') BREAK

. >		greater than (0 is false, not 0 is true)
		if (3 > 4) BREAK
		if ('alfa' > 'beta') BREAK

. >=		greater than or equal (0 is false, not 0 is true)
		if (3 >= 4) BREAK
		if ('alfa' >= 'beta') BREAK

. &		concatenate 2 strings
		string = ' '
		string = string & "Hi"
		if (string ~ ' Hi') BREAK

. &&		concatenate string double-space string
		text = string && string
		if (text ~ ' Hi  Hi') BREAK

. RETURN x		to return from a function [with optional result x]

....			DataTypes

.	NUMERIC		any digits, opts: sign, decimal, exponent
		num = -12.345E-6	! numeric assignment
.	HEXADECIMAL		starts with 0x, followed by 0-9, A-F
		num = 0x00A
		if (num ~ 10) BREAK	! num NotEqual 10 is false: BREAK is not activated
.	BINARY		starts with 0b, followd by 0's and 1's
		num = 0b00101
		if (num ~ 5) BREAK
.	STRING		sequence of characters, enclosed in  ' ' or " "
		string = 'alfa' && "beta" && "'gamma'" && '"delta"'
.	Arrays		1- or 2-dimensional, numeric and string columns possible for same array.
.	$myVariable	Global numeric, text, or array. May be used anywhere
.	$txtRC		return code returned from DLG calls
.	$CR		carriage return character
.	$LF		line feed character
.	$CRLF		carriage return plus line feed characters
.	$TAB		tabulator character
.	$CMDLINE	command line string, e.g: HicEst.exe "this string is in $cmdLine"
.	$TXT		returned from image DLGs with last image path
.	$numRC		numeric returned from DLG calls
.	$		loop number used in array expressions

.TIME(SECondssince=tStart)				! to get execution time below (Run-mode)
....			IF

. IF()			IF(arg) is executed only if arg evaluates to nonzero
. ELSEIF()		ELSEIF(arg) is executed only if arg evaluates to nonzero
. ELSE			executed after IF or ELSEIF was found to be 0
. ENDIF			terminates the IF statement
.		available conditions:
.			== equal to
.			~  not equal to
.			>= greater than or equal
.			<= less than or equal
.			>  greater than
.			<  less than
.			+  OR to combine 2 conditions
.			*  AND to combine 2 conditions
.			== equal to
.			== equal to
		try = 0
		IF(try ~ 0)		! logical NOT
		    BREAK
		ELSEIF(try > 1)	! logical GREATER
		    BREAK
		ELSE
		    IF(done == 'nothing')
		        BREAK
		    ELSEIF(done < '')
		        BREAK
		    ELSE
		        done = 'YES'
		        try = 1
		    ENDIF
		ENDIF

		IF( (try <= 0) + (done ~ 'YES') ) BEEP('>e a e a e 3a') ! 1-line IF
		IF( done == 'YES') BEEP('e e e 3c')

....			Loops
.			More: press F1 >>>Sample  7 Loops.hic<<<
. DO		DO n = count OR startLoop [, endLoop [stepSize ]]
. EXIT		to exit a loop before the end of Loop is reached
. ENDDO		terminates a loop
.			each of the 5 DOs loops 3 times.
		n = 0
		DO				! DO forever (needs an EXIT stmt)
		    n = n + 1
		    IF(n == 3) EXIT
		ENDDO

		DO i = 3.9			! DO n times (def stepsize = 1)
		    n = n + 1
		ENDDO

		DO i = 1.5, 3.9		! DO from, to (def stepsize = 1)
		    n = n + 1
		ENDDO

		DO i = 1.5, -0.9, -1		! DO from, to, stepsize
		    n = n + 1
		ENDDO


....			Strings

		string = '123'		! string is self-defining
		string = 'may change'	! change length of string
		string = ''		! no content

		IF (value == 'this one') BREAK ! useful while debugging

. CHAR()		convert number to character.  Reverse is ICHAR()
		letterA = CHAR(65)
		numA = ICHAR(letterA)

. DEC()			convert string to decimal: num = DEC(string [,nthValue])
		decimal = DEC(' -1.234E2 ')
		if (decimal ~ -123.4) BREAK
		DEC( "value = -1234.56", 1)	! 1 is the nth numeric value in string
		decimal = DEC("Num value 2 is pi = 3.14 (2 decimal places)", 2)
		if (decimal ~ 3.14) BREAK

. FMT()			convert numeric to string of defined length
		n = -123.499
		fmtd = FMT(n, 8)		! -123.499     max 8 places
		fmtd = FMT(n, 6)		! -123.5       max 6 places
		fmtd = FMT(n, 4)		! -123         max 4 places
		fmtd = FMT(123.456, 'C2')	! $123.46      $ currency (2 places)
		fmtd = FMT(-12.34, 'D4')	! -0012        integer digits (4 places)
		fmtd = FMT(12, 'E1')	       ! 1.2E+001     exponential (1 place)
		fmtd = FMT(n, 'F1')		! -123.5       fixed-point (1 place)
		fmtd = FMT(1.2345678, 'G6')! 1.23457      6 places
		fmtd = FMT(15, 'H6')		! 00000f       hexadecimal (6 places)
		fmtd = FMT(n, 'i6')		! -000123      integer (6 places)
		fmtd = FMT(15, 'o6')		! 000017       octal (6 places)
		fmtd = FMT(15, 'b6')		! 001111       binary (6 places)
. ICHAR()		convert character to number.  Reverse is CHAR()
		num = ICHAR('A')
....
. INDEX()		idx = INDEX(string, text ["Case|Back|Word|Scan"]): Get position of text in string
		idx = INDEX('abc ABC', 'x')	! x not found
		IF(idx ~ 0 ) BREAK
		idx = INDEX('abc ABC', 'B')	! default is case insensitive
		IF(idx ~ 2) BREAK

.	Case	(optional)
		idx = INDEX('abc ABC', 'B', 'Case')
		IF(idx ~ 6) BREAK

.	Back	(optional)
		idx = INDEX('abc ABC', 'b', 'Back')
		IF (idx ~ 6) BREAK

.	Word	(optional)
		idx = INDEX('abc ABC', 'ABC', 'Word')	! case insensitive
		IF (idx ~ 1) BREAK

.	Scan	(optional)
		idx = INDEX('abc ABC', 'Cb', 'Scan')	! search first character
		IF (idx ~ 2) BREAK

.		Combinations are possible
		idx = INDEX('abc ABC', 'b', 'Case Back')
		IF (idx ~ 2) BREAK
....
. LEN()		get the length of a string: L=LEN(string) or ARRAY: L=LEN(array) == nRows.nColumns
		L = LEN('abc')
		if (L ~ 3) BREAK
		testMatrix(2, 3) = 0 ! for the next line create a testMatrix with 2 rows and 3 columns
		L = LEN(testMatrix)  ! LEN results in => rows + columns/1000

. LEN_TRIM()		get the length of end-trimmed string
		L = LEN_TRIM('A B C    ')
		if (L ~ 5) BREAK
....
. SET()		At compile time or run time: set variables, e.g: SET(n=13.4, str='alfa', arr=MyArr(), m=0, t="xyz")
.		If the compiler cannot know the numeric type of variable myNum: SET(myNum=0)
.		If the compiler cannot know the string type of variable myText: SET(myText=' ')
.		If the compiler cannot know the array type of variable myArray: SET(myArray() )
.		Examples of "cannot know" are eg:  LOAD(varUnknownTypeA, varUnknownTypeB, ...)
.		SET can compact many code lines of type a=b (b is constant or known variable) to 1 line.
....
. SUBSTRING()		part of a string: SUBSTRING(str, startSub [, lengthSub])
		text = 'abcdefgh'
		substring = text(1) && text(3) && text(5)
		substring = 'ABCDEF'(3)			! a single character of the string
		if (substring ~ 'C') BREAK
		substring = SUBSTRING('ABCDEF', 3, 2)	! start at pos = 3, length = 2
.		if (substring ~ 'CD') BREAK
		substring = SUBSTRING('ABCDEF', 3)		! from pos =3 to end of string
		if (substring ~ 'CDEF') BREAK
....
. TRIM()		make an end-trimmed string
		string = "A B C     "
		string = TRIM(string)
		if (LEN_TRIM(string) ~ 5) BREAK

. TRIM2()		make a start-and-end-trimmed string
		string = "   A B C   "
		string = TRIM2(string)
		if (string ~ "A B C") BREAK

.		Note:	help for ARRAY(), EDIT(), FILE(), TIME(), WRITE(), DLG() host many string cmds

....			Numeric

. ABS()			absolute value
		result = ABS( -1.234e2 )
		if (result ~ 123.4) BREAK

. EXP()			Exponential Function
		result = EXP( 1 )
		if (result ~ 2.718281828459045) BREAK
		if (LOG( result ) ~ 1) BREAK

. FRAC()		make integer from fraction: fractionalPart = FRAC(numValue, digits)
		fract = FRAC(123.045, 3)
		IF ( fract ~ 45 ) BREAK

. IPOL()		ip = IPOL(xi, xy [, p3]) Numerical interpolation, integration, differentiation (Akima algorithm)
.	xi	interpolation x (scalar), no p3 for interpolation
.		integration:	p3 = upper limit, xi = lower limit
.		dy/dx:		p3 = xi - 1
.		d2y/dx2:	p3 = xi - 2
.	xy	matrix:	column 1 = x values
.			column 2 = y values
.	result = IPOL(xi, xy [, p3]) ! scalar result
.			More: press F1 >>>Sample 10 Interpolation & Co<<<
....
. LOG()			Natural logarithm (base e). Optional 2nd argument is base
		result = LOG( 2.718281828459045 )
		if (result ~ 1) BREAK
		result = LOG( 100, 10 )
		if (result ~ 2) BREAK

. MOD()		Remainder of arg1 divided by arg2
		result = MOD( -3.51, 3.4 )
		if (result ~ -0.11) BREAK

. RAN()		random number RAN(A [, B]) = random(A [+- B])
		x = RAN(1)		! x = 0...1
		x = RAN(1000)		! x = 0...1000
		x = RAN(-7.5, 0.5)	! x = -8...-7

. TRUNC()		truncate decimal places, eg: TRUNC(12.34567, 2) equals 12.35
		x = TRUNC(12.34567, 2)
		IF( x ~ 12.35 ) BREAK

. COS()			cosine COS(x), eg: COS(pi/2) equals 0
		pi = 2 * ASIN(1)		! calculate pi
		zero = COS(pi/2)

. SIN()			sine SIN(x), eg: SIN(pi/2) equals 1
		pi = 2 * ASIN(1)		! calculate pi
		one = SIN(pi/2)

. TAN()			tangent TAN(x), eg: TAN(pi) equals 0
		pi = 2 * ASIN(1)		! calculate pi
		zero = 2 * TAN(pi)

. ACOS()		arccosine ACOS(x): inverse function of COS(x)
		pi = ACOS(-1)			! calculate pi

. ASIN()		arcsine ASIN(x): inverse function of SIN(x)
		pi = 2 * ASIN(1)		! calculate pi

. ATAN()		arctangent ATAN(x): inverse function of TAN(x)
		pi = 4 * ATAN(1)		! calculate pi

. COSH()		hyperbolic cosine COSH(x)
		one = COSH(0)

. SINH()		hyperbolic sine SINH(x)
		zero = SINH(0)

. TANH()		hyperbolic tangent TANH(x)
		zero = TANH(0)

. CEILING()		Smallest integer ≥ argument
		result = CEILING( -3.51 )
		if (result ~ -3) BREAK

. FACTORIAL		$ variable to execute a statement multiple times in 1 step
.			More: press F1 >>>Sample  4 Spirals, $, XEQ, F-keys.hic<<<
		$MAX = 4	! sets upper limit of internal loop to 4, start is always 1
		factorial = 1 ! to set an initial value
		factorial = factorial * $ ! loops internally $ = 1..$MAX
		if (factorial ~ 24) BREAK

. FLOOR()		Greatest integer <= argument
		result = FLOOR( -3.51 )
		if (result ~ -4) BREAK

. INT()			largest integer not exceeding ABS(argument)
		result = INT( -3.51 )
		IF (result ~ -3) BREAK

. NINT()		Round to nearest integer
		result = NINT( -3.51 )
		if (result ~ -4) BREAK

. MAX()		Maximum of arguments
		result = MAX( 6, -3.51, 3.4 )
		if (result ~ 6) BREAK

. MAXLOC()		Location of maximum argument
		result = MAXLOC( 6, -3.51, 3.4 )
		if (result ~ 1) BREAK

. MIN()		Minimum of argument
		result = MIN( 6, -3.51, 3.4 )
		if (result ~ -3.51) BREAK

. MINLOC()		Location of Minimum argument
		result = MINLOC( 6, -3.51, 3.4 )
		if (result ~ 2) BREAK

. AND()			Bitwise logical AND of arguments, eg: AND(0x0007, 0b1001) equals 1
		result = AND(0xA, 3)
		if (result ~ 2) BREAK
		IF (AND(0x0007, 0b1001) ~ 1) BREAK

. OR()			Bitwise logical OR of arguments, eg: OR(1, 4) equals 5
		result = OR(0x0001, 0x02)
		if (result ~ 0b011) BREAK
		IF (OR(1, 4) ~ 5) BREAK

. EOR()			Bitwise logical Exclusive OR  of arguments eg: EOR(0b001, 0b100) equals 5
		result = EOR(0b0111, 0b0011)
		if (result ~ 0b0100) BREAK
		IF (EOR(0b001, 0b100) ~ 5) BREAK

....			Optionals

. EDIT()		EDIT()		perform standard string operations.

.	Text			Provide base text for many commands
		EDIT(Text="THIS TEXT IS AN EXAMPLE")

.	APpendto	= base in EDIT(Text=object, Appendto=base)
		base = "THIS TEXT IS AN EXAMPLE"
		EDIT(Text=" and this is appended", APpendto=base)
		IF(base ~ 'THIS TEXT IS AN EXAMPLE and this is appended') BREAK

.	Case		= n: make next searches case sensitive if Case ~ 0
		EDIT(Text="aa AA", Case=1, Right="A", GetPos=num)	! num == 4

.	ClipBoard		= n: copy n characters of Text to clipboard (with Mark1 starts from Mark1)
		EDIT(Text='abcdef', Mark1=2, ClipBoard=3) ! clipboard == 'cde'

.	ClipboardToText	= txt1: clipboard is written to txt1 by EDIT(ClipToText=txt1)
		EDIT(ClipboardToText = txt1) ! txt1 is overwritten
		IF (txt1 ~ 'bcd') BREAK

.	CoPyto		= target in EDIT(Text=base, Mark1=charNr, CoPyto=target)
		EDIT(Text="THIS TEXT IS AN EXAMPLE", Mark1=6, Mark2=9, CoPyto=target)
		IF(target ~ 'TEXT') BREAK

.	CouNT			count occurences in Text
		FILE(Name=$AppDataPath & '\TestFile.txt', FileCopyToText=TestFileAsString) ! copy demo to string
		bytes = LEN(TestFileAsString) ! count bytes (to see file contents click F1)
		items = EDIT(Text=TestFileAsString, Count=':')	! count items separated by ":"
		lines = EDIT(Text=TestFileAsString, Count=$CRLF) ! count lines

.	Delete			delete number of characters or string at current position
		txt1 = "THIS TEXT IS AN EXAMPLE"
		EDIT(Text=txt1, Delete=5)
		if (txt1 ~ 'TEXT IS AN EXAMPLE') BREAK
		EDIT(Text=txt1, Delete='TEXT IS AN')
		if (txt1 ~ ' EXAMPLE') BREAK

.	Find			= c: letter(eg c='x'), digit(eg c='3'), punctuation(eg c=';'), whiteSpace((eg c=' '), or O for letterORdigit (capital O, not digit 0)
		EDIT(T = '...ABC', Find='x', GetPosition=lett1)
		txt1 = ' text, 123 digits, punctuation, whitespace'
		EDIT(T = txt1, Find='x', GetPosition=lett1)
		SUBSTRING(txt1, lett1)
		EDIT(T = txt1, Find='6', GetPosition=lett1)
		SUBSTRING(txt1, lett1)
		EDIT(T = txt1, Find='.', GetPosition=lett1)
		SUBSTRING(txt1, lett1)
		EDIT(T = txt1, Find=' ', GetPosition=lett1)
		SUBSTRING(txt1, lett1)
		EDIT(T = txt1, Find='O', GetPosition=lett1) ! O for letterORdigit (capital O, not digit 0)
		SUBSTRING(txt1, lett1)

.	NotFind			= c:  letter(eg c='x'), digit(eg c='3'), punctuation(eg c=';'), whiteSpace((eg c=' '), or O for letterORdigit (capital O, not digit 0)
		EDIT(T = '123ABC!', NotFind='O', GetPosition=punct1)
		IF(punct1 ~ 7) BREAK

.	GetPosition		string position in Text
		EDIT(T="AB;CDE", Right=";", GetPos=idx)
		IF(idx ~ 3) BREAK

.	GetRow			get line-number containing the next 'find'
		FILE(Name=$AppDataPath & '\TestFile.txt', FileCopyToText=myfileAsString)
		EDIT(Text=myfileAsString, Right="Line", GetRow=num)

.	Insert			insert string at current position
		insertTo = "INSERT >>here<<"
		EDIT(Text=insertTo, Right='here', insert='inserted ')
		IF(insertTo ~ 'INSERT >>inserted here<<') BREAK

.	Left		= x:  If x is Text, move left to x.  If x is num, move left x characters
		EDIT(Text='abcdef', Right=999, Left=3, M1=-1, M2=1, CopyTo=string)
		if (string ~ 'cde') BREAK
		EDIT(Text='-q- search *q* left of end', Right=999, Left='q', GP=testT,
		    M1=-1, M2=1, CopyTo=string)
		if (string ~ "*q*") BREAK
		FILE(Name=$AppDataPath & '\TestFile.txt', FileCopyToText=myfileAsString)
		EDIT(Text=myfileAsString, Right=999, Left="new", GetRow=num)

.	Mark1		= m1 in EDIT(Text=source, ..., Mark1=m1, ...) sets selection start to m1
.	Mark2		= m2 in EDIT(Text=source, ..., Mark1=m2, ...) sets selection end to m2

.	MoVeto		= target in EDIT(Text=base, Right=object, MoVeto=target)
		base = "THIS TEXT IS AN EXAMPLE"
		EDIT(Text=base, MoVeto=target)	! same as target=base with subsequent base=""
		EDIT(Text=target, Right='TEXT ', M1=0, M2=5, MoVeto=base)
		IF(base ~ 'TEXT ') BREAK
		EDIT(Text="A constant cannot be changed", R="be", M1=0, M2=3, MV=txt1)

.	Parse		= string (separated by SEP=..)  EDIT(T='alfa beta', SEP=' ', P=x, P=y)
		EDIT(T='alfa; beta;', SEP=';', Parse=st1, P=st2) ! end seps
		EDIT(T=' "beta",  " alfa"', SEP='""', P=st1, P=st2) ! start AND end seps
		IF( (st1 ~ 'beta') + (st2 ~ ' alfa') ) BREAK

.	ParseNumeric		EDIT(T='12 34', SEP=' ', ParseNum=v1, PN=v2)
		EDIT(T='123 456', SEP=' ', ParseNumeric=one23, PN=four56) ! end sep
		EDIT(T='@123@ --- @456@', SEP='@@', PN=one23, PN=four56) ! start+end sep
		EDIT(T='123 "alfa"', SEP=' ', PNum=one23, P=st1)	! mixed num and txt

.	REPeat			= n: repeat the following commands max n times
		txt1 = "-"
		EDIT(T=txt1, REPeat=5, Insert= "    x    y" )		! LEN(string) == 50
		txt1
		EDIT(T=txt1, REP=5, Del="x", Ins=";", Del="y", Ins="|" )
		txt1
.	RePLaceby	= objectB in EDIT(Text=source, Right=objectA, RePLaceby=objectB)
		source = "THIS TEXT IS AN EXAMPLE"
		EDIT(Text=source, Case=1, R='EX', M1=0, M2=1, RePLaceby='-ex-')
		IF(source ~ 'THIS T-ex-T IS AN EXAMPLE') BREAK

.	Right		= x: If x is Text, move right to x.  If x is num, move right x characters
		EDIT(Text='abcdef', Right='b', GetPosition=x)
		EDIT(Text='abcdef', Right=4,   GetPosition=x)
		EDIT(Text='abcdef', Right='b', Mark1=0, Mark2=2, CopyTo=string)
		if (string ~ 'bcd') BREAK
		FILE(Name=$AppDataPath & '\TestFile.txt', FileCopyToText=myfileAsString)
		EDIT(Text=myfileAsString, Right="new", GetRow=num)

.	Row		Set row for later use
		FILE(Name=$AppDataPath & '\\TestFile.txt', FileCopyToText=myfileAsString)
		EDIT(Text=myfileAsString, SEP=$CRLF, Row=2)

.	SEParator		sets the separator between phrases
		EDIT(T="a b,c d,e f", SEP=",", Count=lines)

.	SetPosition		= n: sets current position to n
		EDIT(T='abcdef', SetPos=999, Mark2=0, Mark1=-1, CoPyto=string)
		if (string ~ 'ef') BREAK	! the 2 last characters

.	TextToWords		t convert separators of t to commas
		EDIT(T="alfa = -1.23;gamma!!!!delta", SEP=" ;!", TextToWords=words)
		ARRAY(CSV=words, SEP=",", Name=wordArray)	! check wordArray with F1

..........................................................
. FILE()		File operations. Keyword sequence is relevant.
		RestoreTestFile()

.	AppendText		append to end of file, complete line with $CRLF
		FILE(Name=$AppDataPath & '\\TestFile.txt', AppendText='Tip: Click Field in result column set/reset a bookmark' & $CRLF)

.	CouNT			bytes, lines, count wildcard-files ("$" or "*" in Name=...)
		FILE(Name=$AppDataPath & '\PCspeed.txt', FileLength=fileBytes)
		FILE(Name=$AppDataPath & '\PCspeed.txt', Count=fileLines)
		FILE(Name= $AppDataPath & '\*.*', Count=files)
		FILE(ERR=999, Name='D:\Fotos\*.jpg', SubDirs=1, Count=files)

.	DELeteRow		delete a row from existing file
		FILE(Name=$AppDataPath & '\\TestFile.txt', DELeteRow=6)

.	Dir			Create Dir if it not existing
		FILE(Dir=$AppDataPath)

.	DRive			available drives on this computer
		driveCount = FILE(DRive=driveString)	! eg driveString = 'C:\;D:\;'

.	EXISTs			check for existing file
		FILE(Name=$AppDataPath & '\\TestFile', EXISTs=yes)	! yes == 1 if existing
		IF(yes) FILE(Name=notExisting)

.	FileDELete		delete a file
		FILE(FileDELete='someFile.string') ! FileDELete has NO error message if not found

.	FileRenameTo		new name of the file
		FILE(ERRor=0, Name=$AppDataPath & '\\TestFile.txt', FileRenameTo='c:\Temp\newName')
		FILE(ERRor=0, Name='c:\Temp\newName', FileRenameTo=$AppDataPath & '\\TestFile.txt')

.	FileCopyToFile		copy file to new file. An existing file is overwritten.
		FILE(Name=$AppDataPath & '\\TestFile.txt', FileCopyToFile=$AppDataPath & '\copiedTestFile.txt')

.	FileCopyToText		Read complete file to Text
		FILE(Name=$AppDataPath & '\\TestFile.txt', FileCopyToText=contents)	! check contents using F1

.	FoundinRow		find next rowNr containing text (starts after last Row=..)
		FILE(Name=$AppDataPath & '\PCspeed.txt', Text='37', FoundinRow=num)
		FILE(Name=$AppDataPath & '\PCspeed.txt', Row=num, RowToText=string)

.	GetChangeTime		Localized time when the file was last written. Convert times using TIME
		FILE(Name=$AppDataPath & '\\TestFile.txt', GetChangeTime=string)

.	GetFileDir		Extract the directory (without trailing "\") from a complete path
		FILE(ERRor=0, Name=$AppDataPath & '\\TestFile.txt', GetFileDir=string)

.	GetFileExtension	Extract the extension (with prefixed dot) from a complete path
		FILE(ERRor=0, Name=$AppDataPath & '\\TestFile.txt', GetFileExt=string)

.	GetFileName		Extract the file name (without extension) from a complete path
		FILE(Name=$AppDataPath & '\\TestFile.txt', GetFileName=string)

.	GetImageTime		Read time of exposure for f files
		FILE(Error=1, Name='C:\Temp\myFoto.JPG', GetImageTime=string)
.				(Error ~ 0: script continues running, string becomes '')

.	ListDirs		list-file-name for subdirectories of DIR=...
		nDirs = FILE(DIR='c:\Temp', ListDirs=$AppDataPath & '\dirs.txt')

.	ListFiles		list WildCard_Files, pattern is in File
		nFiles = FILE(Name=$AppDataPath & '\*.txt', ListFiles=$AppDataPath & '\files.txt')

.	Name	The fully qualified name of the file to work on
.			Name = full path file name(s). Wildcards * and ? possible for some commands
.			Do not use any of / \ : * ? '' < > or verticalBar in filenames
		FILE(Name=$AppDataPath & '\PCspeed.txt', FileLength=fileBytes)	! returns number of bytes

.	RemoveDUPs	Remove all duplicate lines of a file
		FILE(Name=$AppDataPath & '\PCspeed.txt', RemoveDUPs=1)

.	RemFilRowsWith	= t: Remove all lines containing the string t (case sensitive)
		FILE(Name=$AppDataPath & '\\TestFile.txt', RemoveFileRowsWith="Hi there")

.	Row			= n: Set current file row = n. Use with RowToText
		FILE(Name=$AppDataPath & '\\TestFile.txt', Row=3)

.	RowToText		Read row = rowNr to Text
		stringLength = FILE(Name=$AppDataPath & '\\TestFile.txt', Row=3, RowToText=string)

.	SelectDirectory	Calls the Windows File Manager
.		FILE(SelectDirectory=chooseFolder)

.	SelectFile		Calls the Windows File Manager
.		FILE(SelectFile=chooseFile)

.	SubDirs			SubDirs =0 to exclude (default), =1 to include subdirs
		nFiles = FILE(Name='c:\Temp\*.txt', SubDirs=1, ListFiles=$AppDataPath & '\\txtFiles.txt')

.	TexttoFile		Initialize a file to Text (after that use AppendText)
.	Text			Text that comes from script, or Text that goes to script
.	TexttoRow		Write/replace/insert text to Row nr
.			Row may be non-integer or be beyond the current file length:
		FILE(Text='ORIGINAL FILE LINE 1 OF ' & $AppDataPath & '\\TestFile.txt' & $CRLF, TextToFile=$AppDataPath & '\\TestFile.txt')
		FILE(Name=$AppDataPath & '\\TestFile.txt', AppendText='ORIGINAL FILE LINE 2' & $CRLF)
		FILE(Name=$AppDataPath & '\\TestFile.txt', Text='REPLACED original file line 2' & $CRLF, TextToRow=2)
		FILE(Name=$AppDataPath & '\\TestFile.txt', Text='INSERTED as file line = 0.2' & $CRLF, TextToRow=0.2)
		FILE(Name=$AppDataPath & '\\TestFile.txt', Text='INSERTED as file line = 2.5' & $CRLF, TextToRow=2.5)
		FILE(Name=$AppDataPath & '\\TestFile.txt', AppendText='APPENDED to this file' & $CRLF)
		FILE(Name=$AppDataPath & '\\TestFile.txt', Text='INSERTED as file line = 8' & $CRLF, TexttoRow=8)
		FILE(Name=$AppDataPath & '\\TestFile.txt', FileCopyToText=string)
		MSG(Text=string) ! WRITE(PoPup, Size=44, X=44, Y=44)

.	ERRor			~ 0: run-mode CONTINUES in case of error
		filesInDir = FILE(Err=1, Name='Z:\HicEst\*.???') !'*'==any char, '?'==1 char
............................................................
. FIT()		iters = FIT(Theory="XMC($,3)=f(XMC,p,$)", Parms=p, XMY=XMC) ! 1-liner
.			iters = FIT(Theory="theory(p,XMC)") ! if > 1 line needed for theory

.			FUNCTION theory(p, XMC)
.			    calculates values XMC(..,3) as a function of p(..,2) and x = XMC(..,1)
.			END

.	p	parameter array
.		column 1: actual parameters (input)
.		column 2: standard deviation (output)
.		column 3 etc parameter correlations (output)
.	XMC	x, measured y, calculated y (array)
.		column 1: the independent variable x (input)
.		column 2: the observed values M (input)
.		column 3  calculated values C (output)
.	returns	number of iterations performed, success if > 0

.	EXAMPLE 1+2:	Define data and parameters before fit can start:
		ARRAY(Name=XMC, CLeaR=1,   Name=pmt, CLeaR=1)
		XMC($,1) = ( 0,22,38,48,66,94,97) ! x values
		XMC($,2) = (59,13,31,64,72,99,84) ! observations
		XMC(7,3) = 0                      ! space for calculations
		pmt(2,4) = 0                      ! 1parms + 1stddev + 2correlations
		pmt(1,1) = 1000                   ! initial value pmt 1
		pmt(2,1) = 2000                   ! initial value pmt 2

.	EXAMPLE 1:	1 parameter-line least-square fit:
		iters = FIT(Theory="XMC($,3)=pmt(1,1) * XMC($,1)", Parms=pmt, XMY=XMC, Residual=res)
		DLG(Rows=2,Cols=2, TI='Best FIT with y=p1*x', AX=3, TI='black: 1-parameter FIT' )
		LINE(AX=3, Col=1,XVec=XMC,  Col=2,YVec=XMC, S='🞉', Draw=9)
		LINE(AX=3, Col=1,XVec=XMC,  Col=3,YVec=XMC, Wid=5, Draw=0)
		DLG(Wid=1/2, Nr=1, TI='1. Best FIT with y=p1*x,  ' && res, Array=pmt, SCROLl=1, TI=',current pmt,std dev')

		FUNCTION OriginLine(p, xmc)
		    xmc($,3) = p(1,2) * xmc($,1)
		END

.	EXAMPLE 2:	2 parameters-line least-square fit:
		iters = FIT(Theory="XMC($,3)=pmt(1,1)+pmt(2,1)*XMC($,1)", Parms=pmt, XMY=XMC, Residual=res)
		DLG(Rows=2,Cols=2, TI='Best FIT with y=p1+p2*x', AX=4, TI='red:2-parameter FIT' )
		LINE(AX=4, Col=1,XVec=XMC,  Col=2,YVec=XMC, S='🞉', Draw=9)
		LINE(AX=4, Col=1,XVec=XMC,  Col=3,YVec=XMC, Wid=5, Draw=900)
		DLG(Wid=1/2,Left=1/2, TI='2. Best FIT with y=p1+p2*x,  ' && res, Array=pmt, TI=',current pmt,std dev,correlaton 1,correlation 2')
		DLG(Kill=1, Kill=3, Kill=4)
.			More: press F1 (eg FUNCTION Theory): >>>Sample  8 FIT.hic<<<
..........................................................

. SORT()		strings, arrays, or files recognized by HicEst. Original is overwritten.
		sortTest = "This is a string. It will be sorted!"

		SORT(Sort=sortTest)	! default separator for a string is the space character
		MSG(TIt="This is a string. It will be sorted!", T=sortTest) !!! WRITE(TT=sortTest, X=250, Y=250)

.	Sort		= string, or array, or a file. Watch to have the correct SEParator.
		SORT(Sort=$AppDataPath & '\TestFile.txt')	! for files the default is SEParator=$CRLF

.	SEParator		$CRLF is the File default, ' ' is the string default
		SORT(Sort=sortTest, SEParator=' ')

.	Column		= num: Column to sort. Default = 1. Arrays NEED the Column keyword
		alfabet($,1) = ('Juliett','Delta','Yankee','Charlie','Zulu','Echo',
		    'Whiskey','Foxtrot','Golf','Hotel','India','Papa','Bravo','Kilo',
		    'Lima','Mike','November','Oscar','Tango','Alfa','Quebec','Romeo',
		    'Sierra','Uniform','Victor','Xray',)
		SORT(Sort=alfabet, Column=1) ! view result using F1 or right mouse

.	Descending		= num. Ascending: num=0, Descending: num=1
		SORT(Sort=sortTest, Descending=1)

.	NoDuplicates		=num: num == 1 removes duplicates from file
		SORT(Sort=$AppDataPath & '\PCspeed.txt', NoDuplicates=1)
............................................................

. SYSTEM()		Calling the Operating System. Keyword sequence is relevant.

.	AppendixFile		=t: t is File name to be searched for a line starting with "#"
.		SYSTEM(AppendixFile='#myAppendix')

.	ClearReturns	=n. With n > 1 returns control to Windows without working off the return stack

.	Height		Get pixel height of window nr (default nr=0: script window)
		SYSTEM(NumbeR=0, Height=hei)
		SYSTEM(NR=0, Height=scriptPixelHeight, Width=scriptPixelWidth)	! size of script window

.	Left		Get left pixel border of window nr
		SYSTEM(NumbeR=0, Left=lef)

.	Top		Get pixel top border of window nr
		SYSTEM(NumbeR=0, Top=top)

.	Width		Get pixel width of window nr
		SYSTEM(NumbeR=0, Width=wid)

.	MouseX		Get mouse horizontal pixel position
		SYSTEM(MouseX=mouseX)

.	MouseY		Get mouse vertical pixel position
		SYSTEM(MouseY=mouseY)

.	NumbeR		Window number as set in DLG

.	RUN		Open or run external programs
! SYSTEM(RUN=0) ! stops RUN-mode
! SYSTEM(RUN=1) ! starts RUN-mode
.		! SYSTEM(RUN='C:\myText.txt')
.		! SYSTEM(RUN='E:\myJPG.JPG')
.		! SYSTEM(RUN='D:\myMP3.mp3'
.		! SYSTEM(Run='calc.exe')
.		! SYSTEM(Run='c:\Temp')
.		! SYSTEM(Run='explorer.exe')
.		! SYSTEM(Run='https://www.HicEst.com/Donate')	! calls web browser
.		! SYSTEM(Run="mailto:experience@HicEst.com

.	QUIT		Terminate HicEst if quit is not 0
.		SYSTEM(QUIT=quit)

.	WAVe		Play a wave file, eg: SYSTEM(WAVe='myWaveFile.wav')
............................................................

. LINE()		Call DLG(..., AXis=ax, ...) must be called BEFORE LINE is called.
		DLG(Rows=4,Cols=4, TI='AXis=13', AXis=13) ! start an all-default AXis (modeless dialog)
.			More: press F1 >>>Sample  2 Plot lines.hic<<<
.			More: press F1 >>>Sample  4 Spirals, $ operator, XEQ, F2 to F12.hic<<<
.			More: press F1 >>>Sample  5 Trigonometric etc.hic<<<

.	AXis		= ax (required) ax is the axis number from the DLG call
.	X		= x (required) Horizontal position of LINE start in x-AXis-units
.	Y		= y (required)   Vertical position of LINE start in y-AXis-units
.	Draw		= RGB (required) D=RGB: DRAW colored line (eg RGB = 900 = red), D < 0: MOVE.
.			START with Draw=-1, CONTINUE with color
		LINE(AXis=13, X=20,Y=20,Draw=-1,  X=80,Y=80,Draw=900)

.	Width		= wide: Line width, CONTINUE line (eg with color Draw = 009 = RGB=blue)
		LINE(AX=13, Y=80, X=10, Width=4, Draw=9)

.			Previous end positions are remembered by LINE:
		DLG(Rows=4, Cols=4, TI='AXis=14', , AX=14, MAX=10, Y=0, MIN=-1, MAX=1 )
		DO x=0, 10, 1/4
		    LINE(ax=14, X=x, Y=COS(x), Width=3, Draw=900)
		ENDDO

.	Broken		= dashLength.gapLength: alternating dashed/dotted and gap
		DLG(Rows=4, Cols=4, TI='AXis=15', BackGround=900, AXis=15, TI='B=1.4 blu, 1.1 yel, 2.1 bla', ForeGround=999)
		LINE(AX=15, X=0, Y=0,Draw=-1, X=100, Y=100, Width=5, Broken=1.4, Draw=9)
		LINE(AX=15, Y=100, X=0,Draw=0, Y=0, X=100, Width=25, Broken=1.1, Draw=990)
		LINE(AX=15, X=0, Y=50, Draw=-1, X=100, Width=8, Broken=2.1, Draw=0)

.	Symbol		= Text: Copy symbols eg from 🞄●○🞅◯🔴🞇🞉⏣⍟⏺⬤⚫🔴▲▼⯇🔼⮌⭮⨯╳❌🞢🞧🕆▢▦◩◪￭◼⬛🞑🞓
		DLG(Rows=4,Cols=4, TI='AXis=16', AX=16, FMT='LOG')
		LINE(AX=16, X=2, Y=20, Symbol="⚫YES", D=0,   X=50, Y=80,
		    S="NO🔴", Width=3, D=900)
		MSG(Text='This is to pause before "Kill" the graphs', B="OkCancel", DefBut="OK")
		DLG(Kill=1, Kill=2, Kill=3, Kill=7, Kill=8, Kil=9, K=11, K=13, K=14, K=15,Ki=16, Kill=88)
		WRITE(POP='')
		WRITE(ToolT='')

.			Get more examples by calling:
		PlotFunctions()

		MSG(Text='This is to pause before "Kill" the graphs', B="OkCancel", DefBut="OK")
		DLG(Kill=1, Kill=2, Kill=3, Kill=7, Kill=8, Kil=9, K=11, K=13, K=14, K=15,Ki=16, Kill=88)
............................................................

. TIME()		= seconds today: result for ALL arguments (except SecSinceLast). Keyword sequence is relevant.
		secondsSinceMidnite = TIME()

.	Numout 		Numeric days + fractional days since (Jan 01, 0001)
		TIME(Numout = numDayAD)

.	Textout 	Current date and time as string YYYY.MM.DD hh:mm:ss
		TIME(Txtout = txtDayAD)

.	Input		Input numeric or string days
		TIME(Input=738885, Textout=date738885)
		TIME(Input="2024-01-01", Numout=dayNr2024_01_01)

.	ADDdays		add or subtract days to/from current date
		TIME(ADDdays = -100, Textout = hundredDaysAgo)

.	PATtern		Format days along a pattern of YY MM DD hh mm ss and any text
		TIME(PATtern="date and time: MM/DD/YYYY, hh:mm", Textout=timeDemo1)

.			Extract date from any string mixed with text:
		TIME(PAT="date and time: MM/DD/YYYY, hh:mm", I=timeDemo1,
		    PAT="YYYYMMDD", T=timeDemo2)

.			Use to extend seconds up to tenths of microseconds:
		TIME(Pattern="YYYY-MM-DD hh:mm:ss.tttttt", Textout=DateTimeDotMicrosec)

.	SECondssince	Get a time difference with regard to t0 from TIME(SECondssince=t0)
		ResultDeltaSeconds = TIME(SECondssince=tStart) ! NOT seconds today !!

		WRITE(PoP='Results from the TIME section', SECondssinceMidnite, numDayAD,
		    txtDayAD, date738885, dayNr2024_01_01, hundredDaysAgo, timeDemo1,
		    timeDemo2, DateTimeDotMicrosec, ResultDeltaSeconds)

.	SLEEP		=n: do nothing for n milliseconds
		TIME(Sleep=1)		! wait for 1 msec

.			Note 1: The FILE function hosts the last time a FILE was changed
		FILE(Name=$AppDataPath & '\PCspeed.txt', GetChangeTime=last_change_time)

.			Note 2: The FILE function hosts the time a FOTO was shot
		FILE(ERRor=0, Name="fullPathMyFoto.jpg", GetImageTime=time_foto_shot)

.			Measure time: tStart was set at the top of this script
		dTime = TIME(SECondssince=tStart)
		dtFmt = FMT(dTime, "F3") && "seconds to execute"
		POP(seconds_for_the_run_section, seconds, dayAfterTomorrow, dayOnly, shortTime, longTime,
		    year, milleniumDays, DateAndTimeNow, hundredHoursFromNow)

............................................................

. BEEP()		BEEP(frequency) or BEEP(string) with string made from c d e f g a h # b ' + - n
.			To adjust Windows sound: System > Sound > Properties > Format
		BEEP(440)		! 440/sec, range is 37...32767
		BEEP('a')		! a is 440 oscillations/second. 250 msec.
		BEEP(">bg g #g")	! duration*2, #g is G sharp, bg is G minor
		BEEP('>c +c -c')	! + is 1 octave up, - is 1 octave down
		BEEP("2g 4g")		! duration for this pitch only, max is 9.
............................................................

. SAVE()		SAVE(FileName, nam1, nam2, ...) to SAVE a selection of symbolic names to file
.				nam is any scalar, variable, or array
.		SAVE(mySAVEfile, mytext, mydate, myarray, mynumber...)

. LOAD()		LOAD(FileName, nam1, nam2, ...) to load the contents of a previous SAVE again
.		SET(txtName=' ', arrayName(), numName=0) ! symbols must be set BEFORE LOAD is called
.		LOAD(mySAVEfile, textname, datename, arrayname, numbername, ...)

		fox($,2) = ('THE', 'BIG', 'BROWN', 'FOX', 'JUMPS')
		fox($,3) = ('OVER', 'the','LAZY',  'DOG')
		fox($,1) = $
		fox($,5) = $^2
		TIME(TextOut=dateAndTime)
		LINESdotCOLUMNS = LEN(fox)
		SET(                                  datetime=' ', FUX(), lincols=0 )

		SAVE( $AppDataPath & '\TestFile.txt', dateAndTime,  fox,   LINESdotCOLUMNS )
		LOAD($AppDataPath & '\TestFile.txt',  datetime,     FUX,   lincols ) ! LOADed to different symbols
............................................................

. WRITE()		WRITE(Clipboard or PoPup or StatusBar or ToolTip [, X, Y])
.	ClipBoard		WRITE(ClipBoard=text)		! fill co=clipboard with text
		WRITE(ClipBoard='This is the invisible ClipBoard')
		EDIT(ClipBoardToText=txt1)  ! get clipboard to txt1

.	PoPup		WRITE(PoPup=text [, X=xAbsolutePixel, y=yAbsolutePixel])
		WRITE(PoPup='This is a PoPup', X=333, Y=444)

.	StatusBar		WRITE(StatusBar=text)
		WRITE(StatusBar='This is the StatusBar')

.	ToolTip		WRITE(ToolTip=text [, X=xAbsolutePixel, y=yAbsolutePixel])
		WRITE(ToolTip='This is a ToolTip', X=444, Y=222)

		DLG(B="OK to clear PoPup and ToolTip")
		WRITE(PoPup='')
		WRITE(ToolTip='')
............................................................
. DLG()			The heart of most HicEst programs
		DLG(B="Dialogs (DLG) handle most HicEst communications")
		DLG(Title = "ESCape",
		    B="DLG can always be closed with an ESCcape key press.")

		DLG(B="This modal Window has to be closed for execution to continue.",
		    LBL="Note: A modal DLG has NO Nr=...|||To close: press this button.")

		DLG(Ti = "Button",  B="The string 'OK' somewhere |
		    in a Button text |makes this button the default.||
		    Even an Enter closes this DLG|with the answer 'OK'.")

		DLG(TI='About modeless windows', L=1/2,
		    B="Many modeless DLGs can be opened simultaneously.||
		    It is used to keep the dialog visible|
		    AND to run the script at the same time.|
		    This allows to fire repeated|commands from a button.||
		    A Button in a modeless DLG closes the DLG only|
		    if a 'OK' is somewhere in the text of the button.",
		    LaBeL="A modeless DLG has a Nr=.. in its call|
		    Nr= must be LEFT of controls.", SIZE=32,BG=822,
		    LBL='DLG(NR=12,LaBeL="This will make a modeless window")',BG=990)

		DLG(TI='More about Modeless windows:', L=1/2,
		    B="Switch modeless windows with Ctrl + Tab",
		    Size=30, FG=900)

		DLG(TItle="Summary of DLG controls and options", LBL="DLG() controls are:",
		    E="Array, Axis, Button, CheckBox, ComboBox, Edit, Image, Label,
		    ListBox, Numedit, RadioButton, SLider, ToolTip", BG=99,
		    LBL="Options not handling a control: placed LEFT of 1st control",
		    E="Columns,ERRor,Height,Kill,Left,NumbeR,OWNER,Rows,Top,Width",
		    LBL="Options modifying a control: placed AFTER the control:",
		    E="Align, FiLTeR, ForMaT, LeftMouse, MAXimum, MINimum, ReadOnly,
		    RightMouse, Rotate, ROW1, SCRoLl, SEParator, SYMbol, Value,
		    WRaP, Xopt, XEQ, Yopt, Zeros",
		    LBL="Options to work LEFT of controls",
		    E="Background, FONT, ForeGround, SIZe, TItle",
		    Button="OK",
		    LBL='Not all modifiers work with all controls')

.	CONTROLS	Summary of how to enter, edit and display data
.	Array		After ARRAY(...,Name=nam): Display matrix: DLG(A=nam [, SCRL=.., WRP=.., Filter=...)
.		More: press F1 >>>Sample  3 Array and Table.hic<<<
		ARRAY(CSV=$AppDataPath & '\Help.hic', SEP=$Tab, Name=helpFileAsMatrix)
		DLG(TI="This is the complete helpfile shown as a matrix", Array=helpFileAsMatrix)

		ARRAY(CSV="1 The quick brown|2 fox|3 jumps over the lazy dog", SEP=" ", NL="|", Name=fox)
		DLG(TI='Made from' && 'ARRAY(CSV="1 The quick brown|2 fox|3 jumps over the lazy dog", SEP=" ", NL="|", Name=fox)', Array=fox)
		DLG(TI='ARRAY(...Filter="x"...): only row 2 contains "x"', Array=fox, Filter='x')

.		To Edit/View Array use  DLG(Array=myArray, ...) with Context Menu
.			(Filter selection, Duplicate, Remove) and Filter(yellow field)
.		in DLG(A=myArray, ..., SCRoLl=n) sets n display lines in DLG
.		To filter column col for text in DLG(Array=myArray, ...) start
.			yellow search field with ":col:text" in yellow search field

.	CLeaR		=1: Clear Name=.. to cols = 0 and rows = 0 (eg reset image gallery to zero)

.	AXis		Draw background for LINE calls. 1 AXis = 1 window. Set BackGround LEFT of AXis, set ForeGround RIGHT.
		DLG(TItle="AXis", Rows=4, Cols=2, BackGround=990, AXis=2, ForeGround=900)

.	MAXimum		=AxisMax. 100 is default (y-Axis can be set following Yopt)
		DLG(TItle='Max=45', Rows=4, Cols=2, AXis=4, MAX=45, Y=0, MAX=45)
		DLG(Title = "LOG vs Date-Time", BackGround=99, Rows=2, Cols=2, AXis=1,
		    X=0, FMT='hh:mm', MAX=2, TI='2 days (Dates are in days)', Y=0, FMT="LOG")

.	MINimum		=AxisMin. 0 is default (y-Axis can be set following Yopt)
		DLG(Title = "MIN=43, MAX=46", BackGround=9, Rows=4, Cols=2, AXis=6,
		    ForeGround=990, MIN=43, MAX=46, Y=0, MIN=43, MAX=46)
		DLG(BG=990, Left=1/2, Top=3/4, Wid=1/4, LBL='AXis dialogs are modeless!', B='OK')
		DLG(Kill=1, Kill=2, Kill=4, Kill=6)

.	Button	= Text or Num. Triggered by Enter/Mouse. Answer in $txtRC/$numRC
		DLG(TItle='4 types', B="Text like this, Num, and Appendix are OK", B=123.4, B="#Appendix")
.			$txtRC is to recover a string return code
.			$numRC recovers a numeric return code
		MSG(TItle="You selected", Text="$TxtRC = " & $TxtRC & "||$NumRC = " & $NumRC)

.	CHeckbox 	Toggle multiple items: DLG(CHk=vec, Val=CHK, XEQ='...', B='OK')
		vec1($) = ('Alex','Bella','Chloe','Daisy','Ethan','Felix')
		txt = ''  ! to start checkbox without check marks
		DLG(CHeck=vec1, Value=txt, XEQ='BEEP(220)', Button='OK') ! vector checkbox
		MSG(Text = 'You checked:' && txt)

.	ComboBox	Editbox + Listbox combined: DLG(CB=myCB, Value=txt, ReadOnly=0/1)
.			With item selected: click somewhere outside of combobox to add item,
.				and with CTRL to remove item
		CB1($) = ('Alex','Bella','Chloe','Daisy','Ethan','Felix','Enter another name')
		CB2($) = ('buys','eats','hates','likes','loves')
		CB3($) = ('chocolate','cars','cigars','icecream')
		DO
		    DLG(ComBo=CB1,Val=valCB1,X=0,  ComBo=CB2,Val=valCB2,  ComBo=CB3,Val=valCB3,
		        Button='OK', Button='Next')
		    IF($txtRC == 'Next') EXIT
		ENDDO

.	Edit		to edit text or array data or display a text file
.	Numedit		to edit numeric data
		txt = "The Edit option of DLG is to change TEXT."
		DLG(Title = "TxtNumEdit",
		    LBL='Edit, for STRING edits:', Edit=txt,SYMbol=1,
		    LBL='Numedit, for NUMER edits:', Numedit=num,SYMbol=1,
		    LBL='(Edit=value) shows:|value||(Edit=value, SYMbol=1) shows:|name = value||A vertical bar breaks the line',
		    BG=90, B='OK')
		DLG(E="Constants will not be stored", Numedit=1.234, B='OK')
.			To edit a text file in ReadOnly mode:
		DLG(B="OK", Edit=$AppDataPath & '\PCspeed.txt', SIZ=14)

.	Image		display bmp, gif, ico, jpg, jpeg, png, wdp, tiff.
.			More: press F1 >>>Sample  6 Photos with HicEst.hic<<<
.	Rotate		=n = 1, 2, 3 to rotate an image by 90°, 180°, 270°
.			DLG(Image=myJPG.jpg',Rotate=2)
.	CLeaR		=1: Clear Name=.. to cols = 0 and rows = 0 (eg reset image gallery to zero)



.	LaBeL		To display text or numbers
		DLG(Title = "Labels",
		    LBL=123.456E-2,BG=90,  LBL='Hello world',Y=0,X=1,BG=990,
		    LBL='Numeric LaBeL',Y=1,X=-2,  LBL="Text LaBeL",X=1,
		    B="OK",Y=1,X=-2,Width=2)

.	ListBox		Select item from list: DLG(ListBox=vec1, Button='OK')
		LB1($) = ('>c','>e','>g',">>'c")
		DLG(BackG=0, ListBox=LB1, Value=v, XEQ='BEEP(v)', BackG=9, ForeG=990,  Button='OK, thru with clicking')
		LB2($) = ('Alex','Bella','Chloe','Daisy','Ethan','Felix')
		DLG(L=0,W=1/6, LiBox=LB2, Value=txtLB, BackGrd=99, ForeGrd=9, XEQ='WRITE(POP=txtLB)', B="OK, thru with clicking")

.	SLider 	pick a numeric value num by dragging a thumb along a horizontal line with range indicator and tooltip
		num = 5
		DLG(TI='min=2,max=9, with range: left=-1 size=2 and XEQ to fire BEEP', Width=1/2, SLider=num, MIN=2, MAX=9, Width=1, Left=num-1, SIze=2, BackGround=9, XEQ='BEEP(440)', B='OK')
		DLG(TI='min=0, max=100, auto', Width=1/2, SLider=num, BackG=9, Width=1, B='OK')

.	RAdiobutton 	To select a single item out of a list.
		RB1($) = ('Alex','Bella','Chloe','Daisy','Ethan','Felix')
		RB2($) = ('buys','eats','hates','likes','loves')
		RB3($) = ('chocolate','cars','cigars','icecream')
		DLG(RAD=RB1,Val=rad1, B='OK')
		DLG(RAD=RB2,Val=rad2, B='OK')
		DLG(RAD=RB3,Val=rad3, B='OK')
		MSG(T='The answer is|' && rad1 && rad2 && rad3)
		DLG(RAD='works', Val=xpl, RAD='also', RAD='with', RAD='scalars',  But='OK')

.	ToolTip	=t.	String t shown when the mouse hovers over the button
		variableTXT = 'this is a text variable'
		variableNUM = -987.654321
		DLG(Title = "ToolTip", LBL = variableTXT,TT="text label",BG=990,
		    LBL = variableNUM, TT="num label",BG=90,
		    B="Mouse over the LaBeLs to see the ToolTip",
		    TT="and this is a button")


.	OPTIONS1	possible LEFT of the first control

.	NumbeR		= nr>0 creates a modeless DLG (execution continues until OK or Escape)
		DLG(Title = "NumbeR", NumbeR=1,
		    Button='With Number=1: modeless window nr 1')

.	Owner		= nr: This modeless DLG has another DLG with NumbeR=nr as parent
		DLG(Number=2, Owner=1, Left=2/4,
		    Button='This is Number=2, Left=2/4. Owner is Nr=1, killed WITH Nr=1')

.	Top		=T relative to height t=0...1,  ( t>1: pixels from top)
		DLG(Top=0.9, Number=3, LBL='Top=0.9')

.	Left		=L relative to left border L=0...1,  ( L>1: pixels to the left)
		DLG(Left=2/4, Top=1/8, Height=1/8, NumbeR=4, LBL='Left=2/4, Top=1/8, Height=1/8, NumbeR=4')

.	Width		=w relative to full screen w=0...1,  ( w>1: width in pixels)
		DLG(Width=1/2, Left=2/4, Top=7/8, Nr=5, LBL='Width=1/2, Left=2/4, Top=7/8')

.	Height		=h relative to full screen  h=0...1  ( h>1: height in pixels)
		DLG(Height=0.10, Left=0.5, Top=0.3, Nr=6, LBL='Height=0.1, Left=0.5, Top=0.3, Nr=6')

.	Columns		position and size of a modeless window, mostly used together with Rows=...
		DLG(Nr=8, Columns=4, Rows=3, LBL='Cols=4,Rows=3,NR=8', B='OK',
		    LBL='Args for Left, Top, Height, Width:| relative 0..1|	absolute > 1')

.	Rows		position and size a modeless window, mostly used together with Columns=...
		DLG(TI='How to divide the screen', Rows=10, Nr=7, Bu="Rows=10, Nr=7, no columns=...||Switch windows with Ctrl+Tab")
		DLG(TI='Modeless 30', Rows=10, Cols=4, Nr=30, H=1/8,  B='Rows=10, Cols=4, H=1/8, Nr=30')
		DLG(Button="OK, Kill these samples", BackGround=900)
		DLG(Kill=1,Kil=2,Ki=3,K=4,K=5,K=6,K=7,K=8, Kill=30)

.	OPTIONS2	possible AFTER the first control

.	Align		"Left" (default), or "Center" or "Right", or "StretcH" (1st capital letter needed only)
		DLG(B="OK", Edit='Center',ALign='C', E='Left', E='Right',AL='R',
		    E='Stretch takes as much space as it needs',AL='S')

.	FiLTeR		=txt  to show only lines with txt
		ARRAY(Wrap="\", CSV="1 The\quick\brown|2 fox|3 jumps over\the lazy dog",
		    SEP=" ", NL="|", Name=fox)
		DLG(TI='only row 2 contains "fox"', Array=fox, Filter='x')

.	ForMaT		LOG axis, Date(YY,MM,DD) ax, Time(hh,mm,ss) ax, BLank ax
		DLG(Title = "loglog", Rs=3, Cs=4, AX=6, FMT="LOG", TI="LOG",
		    Y=0,  FMT="LOG", TI="LOG")
		DLG(Rs=4,Cols=4, W=1/2, AXis=7, X=0, FMT="YYYY", MAX=738885,
		    TI="YEAR (date 2024-01-01 == 738885 days after 0001-01-01)")
		DLG(Rs=4,Cs=4,W=1/2, AXis=11, X=0, FMT="MM/DD", MAX=90, TI="MM/DD")
		DLG(Title = "hh mm", Rs=4,Cs=4,W=1/2, AX=15,
		    X=0, FMT="hh:mm  ", MAX=1, TI="hh:mm")
		DLG(Button="OK, Kill the 4 AXis samples", BackGround=900)
		DLG(Kill=1, K=1, K=2, K=3, K=5, K=6, K=7, K=11, K=15, K=16, K=14)

.	LeftMouse	=t A string to be executed on a button left mouse click
		DLG(Button="beep d g h on left mouse", XEQ="BEEP('>d g h')")

.	ReadOnly	~ 0 makes Edit a ReadOnly display
		DLG(TItle=$AppDataPath & '\PCspeed.txt', B='OK',
		    LaBeL='Edit control marked ReadOnly. Read, no change possible.',
		    Edit=$AppDataPath & '\PCspeed.txt', ReadOnly=1, Background=9)

.	RightMouse	=t A string to be executed on a button right mouse click
		DLG(Button="Please try a right mouse click",
		    RightMouse='MSG(T="The right mouse button was clicked.|
		    You can programm any other action|including a function call")')

.	ROW1		=num. OPEN array with line number num
		ARRAY(CSV=$AppDataPath & '\PCspeed.txt', Name=mySpeedArray, SEP=$TAB)
		DLG(TI='start at line 63', W=1/3, Array=mySpeedArray, ROW1=63, SCRoLl=30, TI='n,1st line initially = 123. SCRoL set to 3')

.	SCRoLl		=num.  Number of lines to show on a page.
		DLG(Title = "SCRoLl array", Width=1/2, A=mySpeedArray, SCRoLl=20, TI='n,SCRoL set to 20')

.	SEParator 	=t to separate input array elements
		DLG(ListBox='agfed; defga', SEP=";", Val=txtLB,
		    XEQ="BEEP(txtLB)", B="To listen: click items of this listbox")

.	SYMbol		to show the variable name in the Edit field
		variableTXT = 'prefix the output with the variable symbolic name'
		variableNUM = -987.654321
		DLG(Title = "SYMBOL",
		    B="With SYMbol the variable name may be overwritten. OK",
		    Numedit=variableNUM,SYMbol=1, Edit=variableTXT,SYM)

.	VALue		=v  has the contents of the selected item of a ListBox or a ComboBox
		DLG(LB='efg; gah; h+cd ', SEP=";", Value=txtLB,
		    XEQ="BEEP(txtLB)", B="To listen: click an item")

.	WRaP		=wrap the maximum number of lines to be shown for an array element

.	XEQ		=t A string to be executed when the button is pressed or clicked
		DLG(Button="execute a BEEP('>dfa')", XEQ="BEEP('>dfa')")
.		DLG(Array=myArray, XEQ='myFunction()') ! in myFunction use $NumRC of $TxtRC for row number
.			More: press F1 >>>Sample  4 Spirals, $, XEQ, F-keys.hic<<<

.	Xopt		The last preceding X or Y positions are continued
.	Yopt		The last preceding X or Y positions are continued
		DLG(Title = "Navigate with TAB", B="1. OK",
		    E="2. X=2",X=2, E="3. ---", E="4. ---",
		    E="5. Y=2",Y=2, E="6. ---", E="7. ---",
		    E="8. ---",E="9. ---", E="10. ---",
		    E="11. X=-2, Y=0",X=-2,Y=0, E="12. X=-2",X=-2,
		    E="13. --- X=0,Y=-2",X=0,Y=-2, E="14. ---",
		    E="15. ---", E="16. --- X=1",X=1, E="17. ---")

.	Background		color RGB 0...999, ForeGround default is automatic
		DLG(Title = "Colors",
		    B='RED    =Red=1..9 +Green=0    +Blue=0    BackGround=900', BG=900,
		    B='GREEN  =Red=0    +Green=1..9 +Blue=0    BackGround=090', BG=90,
		    B='BLUE   =Red=0    +Green=0    +Blue=1..9 BackGround=009', BG=9,
		    B='CYAN   =Red=0    +Green=1..9 +Blue=1..9 BackGround=099', BG=099,
		    B='MAGENTA=Red=1..9 +Green=0    +Blue=1..9 BackGround=909', BG=909,
		    B='YELLOW =Red=1..9 +Green=1..9 +Blue=0    BackGround=990', BG=990,
		    B='WHITE  =Red=9    +Green=9    +Blue=9    BackGround=999', BG=999,
		    B='LITGREY=Red=7    +Green=7    +Blue=7    BackGround=777', BG=777,
		    B='BLACK  =Red=0    +Green=0    +Blue=0.   BackGround=000', BG=0)
		MSg(T=$txtRC, TItle='you clicked')

.	FONT		font just for this Edit or for ALL controls of this DLG
		DLG(Title = "Segoe", Edit="this is Segoe Script", FONT="Segoe Script",
		    B="OK (standard font)")
.		See also menu File/Color and Font

.	ForeGround	color RGB 0...999
		DLG(Title = "Red foreground", Button="Foreground=900", ForeGround=900,
		    SIZe=120)

.	SIZe	=n The font size for this edit control or for all controls
		DLG(B="OK, standard font size is same as script font size",
		    Edit="Edit, SIZe=100", SIZe=100)
		DLG(TI='Font size', SIZe=120,
		    Button="This complete DLG|is FONT size 120", Button="OK")

.	TItle		=t the title t of this DLG (text, or numeric, or blank) or the axis caption
		DLG(Ti=123456789, Button="Title 123456789 is a number")
		DLG(Ti="A string", Button="TItle is a string'")
		DLG(Ti=" ", Button='A TItle that is just a space will not be displayed')
..........................................................
. ARRAY()		initialize 2-DIMENSIONAL ARRAY mtx element by element and column by column:
.			For more details see: >>>Sample  3 Array and Table.hic<<<
		ARRAY(Name=mtx, CLeaR=1)	! reset array to zero elements
.			textCol=1	row $ runs from 1 to 10 == initializing array length:
		mtx($, 1) = ('Numeric (grey)','columns','and','text (white)','columns',
		    'are both','possible','together in','HicEst','arrays')
		mtx($, 2) = $ + 30 ! $ runs from 1 to 10 == max array rows so far:
		mtx($, 3) = mtx($, 2) ^ 2 ! Left hand side new, right hand side defined earlier
		mtx($, 4) = TRUNC(RAN(100), 2) ! left side new, right side some expression
.			show or edit ARRAY() mtx:
		DLG(TI='Type-mixed matrix', Array=mtx,
		    Ti=' ,txt vec,$ + 30 (num),column2 ^ 2 (num),RAN(100) (num)')

.	SUM		get the sum over the elements of a numeric column
.	MAXimum		get the maximum of the elements of a numeric column
.	MAXLoc		get the row nr of the maximum element of a numeric columns
.	MINimum		get the minimum of the elements of a numeric column
.	MINLoc		get the row nr of the minimum element of a numeric column
		ARRAY(Name=mtx, Column=4, SUM=sum, MAX=max, MAXLoc=maxloc,
		    MIN=min, MINLoc=minloc)
		mtx($, 5) = ('SUM=','MAX=','MAXLoc=','MIN=','MINLoc=')
		mtx($, 6) = ( sum,   max,   maxloc,   min,   minloc)

.	MovAvgToCol	=mavg: Join j elements of column C=.. to a moving average in column mavg
.	Join	=j: set the number of elements j to join for MovAvgToCol
.				write something to column 7:
		mtx($, 7) = ('The next','column','is a','moving','average','of column 4.',
		    'Joined','in this example','are 2','elements')
.				write 2-elements-avg of column 4 to column 8:
		ARRAY(Name=mtx, Column=4, MovAvgToCol=8, Join=2)
.				display matrix with column headers:
		DLG(TI='Num/txt mixed matrix', Array=mtx,
		    Ti="0: $,1: Text column,2: $+30,3: ($+30)^2,4: RAN(100),
		    5: column 4,6: result,7: see col 8,8: MovAvg(Join=2)")

.	Name		Symbolic name of the array
.	CSV		Comma Separated Variable or File. Use F1, right mouse, or DLG to display.
.	SEParator	to separate the fields of the array, often this is a comma ","
		ARRAY(Name=mySpeedArray, CSV=$AppDataPath & '\PCspeed.txt', SEParator=';')
.			The width of displayed columns is determined by the character count of the title
		DLG(TI='ARRAY with SEP=";"', Array=mySpeedArray, Title=" ,line,seconds,") ! PCspeedfile treated as CSV-file

.	Title shift	Rearrange or skip column titles
		ARRAY(Name=mySpeedArray, CSV=$AppDataPath & '\PCspeed.txt', SEP=';2 1')
		DLG(Array=mySpeedArray, Title=",col=2 rearranged,col=1") ! columns exchanged

.	SAVe		=fil	write the array mySpeedArray to file fil (full path needed)
		ARRAy(Name=mySpeedArray, SAVe=$AppDataPath & '\PCspeed.txt')
		DLG(TI="To be saved and loaded again", A=mySpeedArray)
.			For any later reUse in HicEst the functions SAVE and LOAD should be used
		SAVE($AppDataPath & '\PCspeed2.mtx', mySpeedArray)
		LOAD($AppDataPath & '\PCspeed2.mtx', mySpeedArray)

.	NewLine		=nl	The character nl will force a new line.
.	Wrap		=W	Characters W will start a new line WITHIN a boxed element
		ARRAY(Wrap="\", CSV="The\quick\brown|fox|jumps over\the lazy dog",
		    SEP=" ", NL="|", Name=fox)
		DLG(TI='ARRAY(Wrap="\", CSV="The\quick\brown|fox|jumps over\the lazy dog", SEP=" ", NL="|", Name=fox)', Array=fox, WRaP=3)

.	Column		=n	To perform operations on column n
		ARRAY(Name=fox, Col=1, SUM=sum)

.	Sort		=col	Sort column=col of the array
		ARRAY(Name=fox, Sort=1)

.	Descending	=d	d=0: ascending sort,  d ~ 0: descending sort of col
		ARRAY(Name=fox, Sort=1, DesCending=1)

.	Find		=txt	row_that_has_txt = ARRAY(Name=.., Column=.., Find=txt)
		foundInRow = ARRAY(Name=mySpeedArray, Col=2, Find='0005')

.	NoDuplicates		=n	n ~ 0: eliminate rows with duplicates in col to sort
		ARRAY(Name=fox, Sort=1, NoDups=1)

.	CSV	files	initialize arrays from CSV files or CSV strings. Usually needs: CSV, Name, SEParator
		ARRAY(CSV=$AppDataPath & '\PCspeed.txt', Name=mySpeedArray)

.	Num VECTOR		generate a column VECTOR, either num OR txt:
		numVector(2) = 100	! this column vector is num
		numVector(3) = 25	! Note: the column index is 1 and may skipped
		numVector(4) = 1.001 * (numVector(2) + numVector(3))
		DLG(TI='Array=numVector, Zeros=0', Array=numVector, Zeros=0)

.	Zeros		~0  blanks zeros for array editor or array graph

.	Mix MATRIX		Column types may be mixed type
		mixMatrix(1,1) = 'A COLUMN is either num or it is txt'
		mixMatrix(1,3) = -12.34
		mixMatrix(1,4) = 'A row vector (or any matrix) may have mixed type COLUMNS'
		mixMatrix(1,5) = 567.89
		mixMatrix(1,6) = 'Num cols grey, txt cols white, undefined is red.'
		DLG(Title = "Another mixed matrix", Array=mixMatrix, WRaP=8)

.	Edit/View Array		use  DLG(Array=myArray, ...) with Context Menu (Filter selection, Duplicate, Remove) and Filter(yellow field)
..........................................................

. MSg()			retcod = MSG(Buttons=.., Defaultbutton=.., Icon=.., Text=.., TItle=..). retcod=1 for OK or Yes, 2 for No, 3 for Cancel
.	Text		=t. t is the (required) Text to be shown
		MSG(Text="A message box||Note: All keywords of this example are default,|except this Text=...")

.	Buttons		=b. b is either of 'Ok', 'OkCancel', 'YesNo', or 'YesNoCancel' (Capital letters are required)
		MSG(Buttons='YesNo', T='only Buttons and this Text are set')

.	Defaultbutton	=db. db selects Button of Buttons=.. to be the DefaultButton
		MSG(B='YNC', DB='No', T='"No" is selected,|"Cancel" stops Run-mode (default)')

.	TItle		=t. t is the message box TItle
		MSG(Title = "TItle=box title", Txt='Text=all options are set in this example', But='YeNoCa', DefBut='Y', Icon='i')

.	Icon		=i. The image i is either of 'Info' or 'i', 'Question' or '?', 'Warning' or '!', 'Error' or 'X'
		MSG(Icon='?', Text='Easy, is it not?', Button="OK")
............................................................

. FUNCTION		(routine, subprogram, subroutine, procedure) callable from several places multiple times
.	RETURN	RETURN val: Optional. Returns from called function with val (txt or num)
.	END	terminates a FUNCTION (and optionally the "MAIN" section of script.)
.			Function code can be anywhere in script, recommended at end of script

		retVal = ExampleA(123.4) ! actual parameter is 123.4, retVal = 246.8
		DLG(Nr=1, B='OK: The END', SIZe=200)
		SYSTEM(WAVe='C:\Windows\Media\Windows Proximity Connection.wav')

		F2() ! F2..F12 run asychronously
.			More: press F1 >>>Sample  4 Spirals, $, XEQ, F-keys.hic<<<

		END

		FUNCTION ExampleA(num)	! dummies (here: num) must be same type as calling arguments
		    val = 2 * num
		    RETURN val
		END

		FUNCTION F2() ! As Time goes by
		    WRITE(PoPup="-bh +be d c -bh 2+c", X=333, Y=333)
		    BEEP("-bh +be d c -bh 2+c")
		    WRITE(ToolTip="get rid of popups and tooltips with the Escape key",x=444,y=444)
		END

		FUNCTION Initialize()
		    RestoreTestFile()
		    RestorePCspeedFile(-1)
		    MSG(Txt='The graph shows|the times needed per step|to update a matrix MTX|1000 times.||Walk thru script with|the Enter key,|or with Menu/Step|to get everything.||Run script with Alt + R,|or Menu/Run|to get interactives only.', Button='O', Icon='i')
		    DLG(Kill=2)
		END

		FUNCTION RestoreTestFile()
		    FILE(FileDELete = $AppDataPath & '\\TestFile.txt')
		    FILE(Name=$AppDataPath & '\\TestFile.txt', AppendText='Tip 1: Take a break: Activate Menu/Timer' & $CRLF)
		    FILE(Name=$AppDataPath & '\\TestFile.txt', AppendText='Tip 2: Ctrl + Enter: New Line' & $CRLF)
		    FILE(Name=$AppDataPath & '\\TestFile.txt', AppendText='Tip 3: Enter on lastchar+2: New Line' & $CRLF)
		END

		FUNCTION RestorePCspeedFile(msec_Graphics)
		    SET(steps=1000)
		    TIME(SECondssince=tA)
		    DO i = 1, steps
		        $speedMtx(i, 1) = FMT(i, 'i5')
		        deltat = TIME(SECondssince=tA)
		        $speedMtx(i, 2) = NINT(1E9 * deltat) / 1E3 !result is in µsec
		    ENDDO
		    ARRAY(Name=$speedMtx, Col=2, MAXimum=maxi,MINimum=mini, SUM=sumi)
		    avg = TRUNC(sumi / steps, 2) ! truncate decimal places to 2
		    TIME(SECondssince=tStart)
		    ARRAY(Name=$speedMtx, Col=2, SUM=sum)
		    DLG(TItle='PC speed: ' & FMt(mini,5) & ' µsec - ' & FMT(maxi,5) & ' µsec, average=' & avg,
		        Rows=1, Cols=2, AXis=2, MAXimum=steps, TItle='Step nr',
		        Y=0, FMT='LOG', MIN=mini, MAX=maxi, TItle='microseconds measured for 1 loop cycle')
		    LINE(Axis=2, X=0, Y=avg, Draw=0, X=steps, W=3, D=900)
		    LINE(Axis=2, X=$speedMtx($,1), Y=$speedMtx($,2), Symb='.', Draw=-9)
		    DLG(L=1/4, W=1/4, Array=$speedMtx, TItle=' ,step nr,µseconds')
		END

		FUNCTION PlotFunctions()
		    xyPLOT(8)
		    xyERRORPLOT(3)
		    Matrix$ColumnsPLOT(2)
		    MATRIXPLOT(7)
		END

		FUNCTION xyPLOT(ax)
		    DLG(R=2,C=4, TI='AXis='&ax, AX=ax, MIN=-4,MAX=4, Y=0,MAX=60)
		    DO x = -4, 4, 1/3
		        y1 = EXP(x)
		        y2 = EXP(-x)
		        LINE(AX=ax, X=x,Y=y1,W=0,S="●",D=0,   Y=y2,S="●",W=2,D=900)
		    ENDDO
		END

		FUNCTION Matrix$ColumnsPLOT(ax)
		    n = 100
		    ax = ax + 0 ! else the compiler does not know it is numeric
		    DO m = 1, 12
		        mtx(n,m) = 0
		    ENDDO
		    mtx($,1) = ($ - n/2) * 7 / n
		    mtx($,2) = SIN(mtx($,1))
		    mtx($,3) = COS(mtx($,1))
		    mtx($,4) = TAN(mtx($,1))
		    mtx($,5) = LOG(mtx($,1))
		    mtx($,6) = EXP(mtx($,1))
		    mtx($,7) = SINH(mtx($,1))
		    mtx($,8) = COSH(mtx($,1))
		    mtx($,9) = TANH(mtx($,1))
		    mtx($,10) = ASIN(mtx($,1))
		    mtx($,11) = ACOS(mtx($,1))
		    mtx($,12) = ATAN(mtx($,1))
		    DLG(Title="Built-in HicEst functions, AX=" & ax, Rows=2, Cols=2, AX=ax,
		        X=0,MIN=-4,MAX=4,  Y=0,MIN=-3,MAX=3)
		    LINE(AX=ax, W=4,
		        Col= 1, XVec=mtx,
		        Col= 2, YVec=mtx, TextA="SIN",  TextZ="SIN",  Draw=0,
		        Col= 3, YVec=mtx, TextA="COS",  TextZ="COS",  Draw=0,
		        Col= 4, YVec=mtx, TextA="TAN",  TextZ="TAN",  Draw=90, OneWaY=1,
		        Col= 5, YVec=mtx, TextA="LOGe", TextZ="LOGe", Draw=9,  OneWaY=0,
		        Col= 6, YVec=mtx, TextA="EXP",  TextZ="EXP",  Draw=600,
		        Col= 7, YVec=mtx, TextA="SINH", TextZ="SINH", Draw=60,
		        Col= 8, YVec=mtx, TextA="COSH", TextZ="COSH", Draw=6,
		        Col= 9, YVec=mtx, TextA="TANH", TextZ="TANH", Draw=550,
		        Col=10, YVec=mtx, TextA="ASIN", TextZ="ASIN", Draw=99,
		        Col=11, YVec=mtx, TextA="ACOS", TextZ="ACOS", Draw=909,
		        Col=12, YVec=mtx, TextA="ATAN", TextZ="ATAN", Draw=99)
		END

		FUNCTION xyERRORPLOT(ax) ! draw error bars in x and y directions
		    DLG(R=4, C=2, TI='AXis='&ax, AX=ax)
		    DO J = 1, 10
		        dx = RAN(0, 10)
		        dy = RAN(0, 20)
		        x = 10 * J + dx
		        y = 40 * (1 + SIN(J)) + dy
		        LINE(AX=ax,W=2,  X=x-dx,Y=y,D=-1,  X=x+dx,Y=y,D=9,  X=x,Y=y-dy,D=-1,  X=x,Y=y+dy,D=9)
		    ENDDO
		END

		FUNCTION MATRIXPLOT(ax)
		    MMM(100,4) = 0 ! set shape of Matrix to 100 rows x 4 columns
		    MMM($, 1) = $  ! $ runs from 1 to rows
		    MMM($, 2) = 20*SIN($/10) + RAN(50,30)	! set column 2 to some expression:
		    DLG(W=1/2,H=1/4,T=3/4, BG=0,  TI='AXis='&ax, AXis=ax,ForeGr=990) ! create axis nr ax
.			set cols 3 and 4 to moving averages of MMM column 2 (Join 2 and 10)
		    ARRAY(Name=MMM,  Column=2, MovAvgToCol=3, Join=2,  MovAvgToCol=4, Join=10)
		    LINE(Ax=ax,  Col=1,XVec=MMM,  Col=2,W=0,Symb="+",YVec=MMM,Draw=999,
		        Col=3,Wid=3,Symb=" ", YVec=MMM,Draw=900,  Col=4,YVec=MMM,Draw=99)
		END
............................................................

....			Appendix
#Appendix		to store a string that does not clutter the script.

1.	An #Appendix string is used like a string constant, e.g.
test = "this text could be in Appendix as well"
2.	It starts with a "#" in column 1
It is retrieved by myTxt = '#myAppendixName'
3.	1 or more lines make the body of the #Appendix
4.	It is terminated with the next "#" in column 1
or with the End Of File
5.	Beyond the 1st #appendix '#' the script is not compiled.
Therefore this may be used to (temporarily) deactivate
the following part of the script.
6.	No DLG control can change the #Appendix.
###






